/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import jclass.chart.ChartText;
import jclass.chart.DerivedInt;
import jclass.chart.Extents;
import jclass.chart.JCAxis;

public class JCAxisTitle
extends ChartText {
    DerivedInt placement = new DerivedInt(16, true);
    JCAxis parentAxis;

    void setParentAxis(JCAxis jCAxis) {
        this.parentAxis = jCAxis;
    }

    public JCAxisTitle() {
        this.isShowing = false;
    }

    public JCAxisTitle(String string) {
        this.setText(string, false);
    }

    public JCAxisTitle(String string, boolean bl) {
        this.setText(string, bl);
    }

    public synchronized void setPlacement(int n) {
        if (n == this.placement.value) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 17: 
            case 18: 
            case 33: 
            case 34: {
                if (this.parentAxis != null && !this.parentAxis.isVertical) {
                    throw new IllegalArgumentException("Invalid title Placement for horizontal axis in JCAxisTitle");
                }
                this.placement.value = n;
                this.placement.isDefault = false;
                this.setChanged(true);
                return;
            }
            case 16: 
            case 32: {
                if (this.parentAxis != null && this.parentAxis.isVertical) {
                    throw new IllegalArgumentException("Invalid title Placement for vertical axis in JCAxisTitle");
                }
                this.placement.value = n;
                this.placement.isDefault = false;
                this.setChanged(true);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid title Placement in JCAxisTitle");
    }

    public int getPlacement() {
        return this.placement.value;
    }

    public void setPlacementIsDefault(boolean bl) {
        if (this.placement.isDefault == bl) {
            return;
        }
        this.placement.isDefault = bl;
        this.setChanged(true);
    }

    public boolean getPlacementIsDefault() {
        return this.placement.isDefault;
    }

    /*
     * Enabled aggressive block sorting
     */
    void fixPlacement(JCAxis jCAxis) {
        if (jCAxis == null) {
            return;
        }
        if (this.placement.isDefault) {
            this.placement.value = !this.parentAxis.isVertical && this.rotation != 0 ? jCAxis.getAnnotationAnchor() : (this.parentAxis.otherAxis != null && this.parentAxis.otherAxis.getAnnotationAnchor() == 16 ? (this.parentAxis.getAnnotationAnchor() == 1 ? 33 : 34) : (this.parentAxis.getAnnotationAnchor() == 1 ? 17 : 18));
        }
        if (jCAxis.isVertical) {
            switch (this.placement.value) {
                default: {
                    this.placement.value = jCAxis.getAnnotationAnchor();
                    return;
                }
                case 1: 
                case 2: 
                case 17: 
                case 18: 
                case 33: 
                case 34: 
            }
            return;
        }
        switch (this.placement.value) {
            default: {
                this.placement.value = jCAxis.getAnnotationAnchor();
                return;
            }
            case 16: 
            case 32: 
        }
    }

    void layout() {
        if (this.isShowing) {
            if (this.parentAxis.isVertical) {
                int n = this.parentAxis.getTop() + (this.parentAxis.getHeight() - this.getHeight()) / 2;
                int n2 = this.parentAxis.getLeft();
                int n3 = this.parentAxis.getLeft() + this.parentAxis.getWidth() - this.getWidth();
                Extents extents = this.parentAxis.getExtents();
                switch (this.placement.value) {
                    case 18: {
                        this.move(n2, this.parentAxis.getTop() - extents.minor);
                        return;
                    }
                    case 2: {
                        this.move(n2, n);
                        return;
                    }
                    case 34: {
                        this.move(n2, this.parentAxis.getTop() + this.parentAxis.getHeight() + extents.major - this.getHeight() - 1);
                        return;
                    }
                    case 17: {
                        this.move(n3, this.parentAxis.getTop() - extents.minor);
                        return;
                    }
                    case 1: {
                        this.move(n3, n);
                        return;
                    }
                    case 33: {
                        this.move(n3, this.parentAxis.getTop() + this.parentAxis.getHeight() + extents.major - this.getHeight() - 1);
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            int n = this.parentAxis.getLeft() + (this.parentAxis.getWidth() - this.getWidth()) / 2;
            switch (this.placement.value) {
                case 16: {
                    this.move(n, this.parentAxis.getTop());
                    return;
                }
                case 32: {
                    this.move(n, this.parentAxis.getTop() + this.parentAxis.getHeight() - this.getHeight());
                    return;
                }
            }
        }
    }
}

